/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertPrincipal;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;

public class ArchivedServerCertBean
extends PanelBean
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTASCD";
    private static final String TRACE_MASKF = "XCRTASCF";
    private static final String TRACE_MASKT = "XCRTASCT";
    private ServerCert certificate = null;
    private ItemDescriptor[][] m_idArchivedServerCertTable;
    private ColumnDescriptor[] m_cdArchivedServerCertTableStructure;
    private int[] m_iArchivedServerCertTableSelection;

    public ArchivedServerCertBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ArchivedServerCertBean(" + certificate + ", " + name + ")");
    }

    public void setArchivedServerCertTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setArchivedServerCertTableSelection(...)");
        this.m_iArchivedServerCertTableSelection = selected;
    }

    public int[] getArchivedServerCertTableSelection() {
        return this.m_iArchivedServerCertTableSelection;
    }

    public void setArchivedServerCertTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setArchivedServerCertTableRowAt(" + index + ", ...)");
        this.m_idArchivedServerCertTable[index] = items;
    }

    public ItemDescriptor[] getArchivedServerCertTableRowAt(int index) {
        return this.m_idArchivedServerCertTable[index];
    }

    public int getArchivedServerCertTableRowCount() {
        if (this.certificate == null) {
            return 0;
        }
        return 7;
    }

    public int getArchivedServerCertTableRowStatus() {
        return 3;
    }

    public ColumnDescriptor[] getArchivedServerCertTableRowStructure() {
        return this.m_cdArchivedServerCertTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        this.initializeTable();
    }

    private void initializeTable() {
        this.m_idArchivedServerCertTable = this.certificate == null ? new ItemDescriptor[0][0] : CertMgtPanelUtils.createCertTable(this.certificate, false);
        this.m_cdArchivedServerCertTableStructure = new ColumnDescriptor[0];
        this.m_iArchivedServerCertTableSelection = new int[0];
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        CertPrincipal principalToSend = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            if (actionCommand.equals("ArchivedServerCertActionsMenu.InstallMenuItem")) {
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, null, this.certificate, this);
            } else if (actionCommand.equals("ArchivedServerCertActionsMenu.ViewArchivedSigningCertificateMenuItem")) {
                principalToSend = this.certificate.getIssuerX500Principal();
                CertMgtPanelUtils.sendTaskletRequest(actionCommand, principalToSend, this);
            } else if (elementName.equals("CloseButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

